/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.List;
import java.util.Map;
import org.astrogrid.samp.SampMap;
import org.astrogrid.samp.SampUtils;

class Callback
extends SampMap {
    public static final String METHODNAME_KEY = "samp.methodName";
    public static final String PARAMS_KEY = "samp.params";
    private static final String[] KNOWN_KEYS = new String[]{"samp.methodName", "samp.params"};

    public Callback() {
        super(KNOWN_KEYS);
    }

    public Callback(Map map) {
        this();
        this.putAll(map);
    }

    public Callback(String methodName, List params) {
        this();
        this.setMethodName(methodName);
        this.setParams(params);
    }

    public void setMethodName(String methodName) {
        this.put(METHODNAME_KEY, methodName);
    }

    public String getMethodName() {
        return this.getString(METHODNAME_KEY);
    }

    public void setParams(List params) {
        SampUtils.checkList(params);
        this.put(PARAMS_KEY, params);
    }

    public List getParams() {
        return this.getList(PARAMS_KEY);
    }

    public void check() {
        super.check();
        this.checkHasKeys(new String[]{METHODNAME_KEY, PARAMS_KEY});
        SampUtils.checkString(this.getMethodName());
        SampUtils.checkList(this.getParams());
    }

    public static Callback asCallback(Map map) {
        return map instanceof Callback || map == null ? (Callback)map : new Callback(map);
    }
}

